//
//  MCPGDatabase+BulkCopy.h
//  MCPostgresPersistence
//
//  Created by Michael Clark on 27/12/08.
//  Copyright 2008 Marketcircle Inc.. All rights reserved.
//

#import <Foundation/Foundation.h>

#import "MCPGDatabase.h"

@interface MCPGDatabase (BulkCopy)

// columns is an array of arrays or column names where the index of a table's name in tables is used to get that tables columns to copy
- (BOOL)copyTables: (NSArray*)tables columns: (NSArray*)columns from: (MCPGDatabase*)fromDB progressDelegate: (id)aDeleg error: (NSError**)error;

- (BOOL)adjustPrimaryKeySequencesForTables:(NSArray *)tables increment:(NSUInteger)increment error:(NSError **)error;

/*!
 @method     copyTable:from:bufferSize:progressDelegate:error:
 @abstract   Copies the data from a table in binary form
 @discussion This method is intended for use with offline copy creation. You pass in the table you'd like copied from the remote connection. You can tune the copy speed by passing in the number of bytes you'd like to copy at a time, for example, one meg at a time. 1 meg may be reasonable for smaller tables, but not so much for large tables. In order to provide feedback to the user, the progress delegate needs to implement methods defined in the MCPGDatabaseBulkCopyProgressDelegate category

 The methods returns true or false based on whether it was able to successfully copy the data. The NSError would have the details of failure.
 */
// columns here is just an array of column names
- (BOOL)copyTable: (NSString*)aTableName columns: (NSArray*)columns from: (MCPGDatabase *)fromDB progressDelegate: (id)aDeleg error: (NSError**)error;




@end




@interface NSObject (MCPGDatabaseBulkCopyProgressDelegate)

- (void)database: (MCPGDatabase*)aDatabase willBeginBulkCopyOfDatabaseNamed: (NSString*)aName totalRows: (NSNumber*)rowCount;
- (void)database: (MCPGDatabase*)aDatabase didCompleteBulkCopyOfDatabaseNamed: (NSString*)aName;

- (void)database: (MCPGDatabase*)aDatabase willStartBulkCopyOfTableNamed:(NSString *)tableName totalRows:(NSNumber *)rowCount;
- (void)database: (MCPGDatabase*)aDatabase didMakeBulkCopyProgress:(int)rows;
- (void)database: (MCPGDatabase*)aDatabase didCompleteBulkCopyOfTableNamed:(NSString *)tableName;

@end

